#ifndef _WINSFL_CPP
#define _WINSFL_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <ShlObj.H>
#include <StdIO.H>

#include "WinSfl.H"
#include "Memory.H"
#include "Conversion.H"
#include "System.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void TextBoxWrite(HWND hWnd, char *sInBuf)
{
  int iLen = SendMessage(hWnd, WM_GETTEXTLENGTH, 0, 0);
  SendMessage(hWnd, EM_SETSEL, (WPARAM)iLen, (LPARAM)iLen);
  SendMessage(hWnd, EM_REPLACESEL, 0, (LPARAM)(LPSTR)sInBuf);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void MsgBox(char *sInBuf)
{
    MessageBox(GetActiveWindow(), sInBuf, "Message", MB_TASKMODAL);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void ErrorMessage(HWND hWnd, char *sInBuf)
{
    HWND hOwner = NULL;

    if(hWnd == NULL)
	{
		hOwner = GetActiveWindow();
	}
    else hOwner = hWnd;

    MessageBox(hOwner, sInBuf ,"Error", MB_ICONHAND + MB_SYSTEMMODAL + MB_TASKMODAL);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void AlertMessage(HWND hWnd, char *sInBuf, char *sTitle)
{
    HWND hOwner = NULL;

    if(hWnd == NULL)
	{
		hOwner = GetActiveWindow();
	}
    else hOwner = hWnd;

    MessageBox(hOwner, sInBuf, sTitle, MB_SYSTEMMODAL + MB_TASKMODAL);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int Get_TextLength(HWND hWnd)
{
    return GetWindowTextLength(hWnd);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD Get_Long(HWND hWnd)
{
    char sBuf[16];
    Get_TextEx(hWnd, sBuf, 16);
    return CharInt(sBuf);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int Get_Int(HWND hWnd)
{
    return (int) Get_Long(hWnd);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void Set_Long(HWND hWnd, long lInput)
{
    char sBuf[16];
    MemCopyLong(sBuf, lInput);
    Set_Text(hWnd, sBuf);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void Set_Int(HWND hWnd, int iInput)
{
    Set_Long(hWnd, (DWORD)iInput);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void Set_Text (HWND hWnd, char *sInBuf)
{
    SendMessage(hWnd, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)sInBuf);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int Get_TextEx (HWND hWnd, char *sOutBuf, int iMaxSize)
{
    int iLen = GetWindowTextLength(hWnd);

	if(iLen > iMaxSize)
	{
		return iLen;
	}

    GetWindowText(hWnd, sOutBuf, iLen + 1);

    sOutBuf[iLen] = '\0';

    return iLen;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// This functions return value must be freed externally

char *Get_Text (HWND hWnd)
{
    int iLen = GetWindowTextLength(hWnd);
    char *sOutVal = (char *) calloc(iLen + 1, 1);

    Get_TextEx(hWnd, sOutVal, iLen);
    return sOutVal;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void CenterWindow (HWND hWnd)
{
    RECT wRect;

    GetWindowRect(hWnd, &wRect);

    DWORD x = (GetSystemMetrics(SM_CXSCREEN)-(wRect.right-wRect.left))/2;
    DWORD y = (GetSystemMetrics(SM_CYSCREEN)-(wRect.bottom-wRect.top+GetSystemMetrics(SM_CYCAPTION)))/2;

    SetWindowPos(hWnd,NULL,x,y,0,0,SWP_NOSIZE|SWP_NOZORDER);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

LRESULT CALLBACK Set_Color(int iFGColor, int iBKColor, int wParam)
{
    static HBRUSH ReUsableBrush;
    DeleteObject(ReUsableBrush);
    ReUsableBrush = CreateSolidBrush(iBKColor);
    SetTextColor((HDC)wParam,iFGColor);
    SetBkColor((HDC)wParam,iBKColor);
    return (LRESULT)ReUsableBrush;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int IsMouseOverHwnd(HWND hWnd)
{
    RECT Rectangle;
    POINT Pointer;
    memset(&Rectangle, 0, sizeof(Rectangle));
    memset(&Pointer, 0, sizeof(Pointer));

    GetWindowRect(hWnd, &Rectangle);
    GetCursorPos(&Pointer);

    return PtInRect(&Rectangle, Pointer);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int OSFileDialog (HWND hOwner, char *sInOutFileName, char *sInDfltExt,
							char *sInTitle, char *sInFilters, char *sInDfltDir,
							int iDlgType, DWORD dwFlags)
{
    char sFileName[MAX_PATH];
    int iRetVal = 0;

    OPENFILENAME OFN;

    if( (iDlgType != OFD) && (iDlgType != SFD) )
	{
		return 0;
	}

    strcpy(sFileName, sInOutFileName);

    OFN.lpstrCustomFilter = NULL;
    OFN.nMaxCustFilter    = 0;
    OFN.lpstrFileTitle    = NULL;
    OFN.nMaxFileTitle     = 0;

    if(!sInFilters)
	{
		OFN.lpstrFilter  = "All-Files\0*.*\0Text-Files\0*.txt\0\0";
	}
    else OFN.lpstrFilter  = sInFilters;

    if(!sInDfltExt)
	{
		OFN.lpstrDefExt = "txt";
	}
    else OFN.lpstrDefExt = sInDfltExt;

    if(!sInTitle)
    {
        if(iDlgType == OFD)
		{
			OFN.lpstrTitle = "Select file to open";
		}
        else if(iDlgType == SFD)
		{
			OFN.lpstrTitle = "Save file as";
		}
    }
    else OFN.lpstrTitle = sInTitle;

    if(!sInDfltDir)
	{
		OFN.lpstrInitialDir = Get_CurrentDirectory();
	}
    else OFN.lpstrInitialDir = sInDfltDir;

    OFN.lStructSize       = sizeof(OFN);
    OFN.hwndOwner         = hOwner;
    OFN.nFilterIndex      = 1;
    OFN.lpstrFile         = sFileName;
    OFN.nMaxFile          = sizeof(sFileName);

    if(dwFlags == 0)
	{
		OFN.Flags = OFN_EXPLORER + OFN_LONGNAMES + OFN_PATHMUSTEXIST;
	}
	else OFN.Flags = dwFlags;

	if(iDlgType == OFD)
	{
		iRetVal = GetOpenFileName(&OFN);
	}
	else if(iDlgType == SFD)
	{
		iRetVal = GetSaveFileName(&OFN);
	}

    strcpy(sInOutFileName, sFileName);

    return iRetVal;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool BrowseDirectory(HWND hOwner, char *sInTitle, unsigned long ulFlags, char *sOutBuf)
{
    LPMALLOC pMalloc;
    LPITEMIDLIST lpItemIDList;
    BROWSEINFO  browseInfo;
    bool bResult = false;

    memset(&pMalloc,0,sizeof(pMalloc));
    memset(&browseInfo,0,sizeof(browseInfo));
    memset(&lpItemIDList,0,sizeof(lpItemIDList));

    if(S_OK != SHGetMalloc(&pMalloc))
	{
		return false;
	}

    memset(&browseInfo,0,sizeof(BROWSEINFO));

    browseInfo.hwndOwner      = hOwner;
    browseInfo.pszDisplayName = sOutBuf;
    browseInfo.lpszTitle      = sInTitle;
    browseInfo.ulFlags        = ulFlags;

    lpItemIDList = SHBrowseForFolder(&browseInfo);

    if(lpItemIDList != NULL)
    {
        strcpy(sOutBuf, "");

        if(SHGetPathFromIDList(lpItemIDList, sOutBuf))
        {
            if( strlen(sOutBuf) > 0 )
			{
				bResult = true;
			}
        }

        pMalloc->Free(lpItemIDList);
    }
    pMalloc->Release();

    return bResult;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

HFONT MakeFont(char *sFontName, int iPointSize)
{
    HDC hDC;
    int CyPixels = 0;
    hDC = GetDC(HWND_DESKTOP);
    CyPixels = GetDeviceCaps(hDC, LOGPIXELSY);
    ReleaseDC(HWND_DESKTOP, hDC);
    int iiPointSize = (iPointSize * CyPixels)/72;
    return CreateFont(0-iiPointSize, 0, 0, 0, FW_NORMAL, 0, 0, 0,
		ANSI_CHARSET, OUT_TT_PRECIS, CLIP_DEFAULT_PRECIS,
		DEFAULT_QUALITY, FF_DONTCARE, sFontName);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void SetFont(HWND hWnd, HFONT hFont)
{
    SendMessage(hWnd , WM_SETFONT, (WPARAM)hFont, (LPARAM)TRUE);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
